/* eslint-disable react-hooks/exhaustive-deps */
import { useEffect, useState } from "react"
import { Loader2 } from "lucide-react"

import { ComponentClassName } from "@/types/utility"
import { cn } from "@/lib/utils"

export function PageLoader({ className }: ComponentClassName) {
  return (
    <div
      className={cn(
        "bg-transparent w-full h-full grid place-items-center",
        className
      )}
    >
      <SpinnerInternal />
    </div>
  )
}

/**
 * Paging loading spinner to allow loading assets in the background.
 *
 * Shows a spinner after given timeout in milliseconds to remove jarring "loading flash."
 * Removing the loading for shorter loading times reduces cognitive load and makes the app appear to load faster.
 * @param param0
 * @returns Spinner or undefined.
 */
function SpinnerInternal({ delay = 500 }: { delay?: number }) {
  const [disableSpinner, setDisableSpinner] = useState(true)

  useEffect(() => {
    const handler = setTimeout(async () => {
      setDisableSpinner(false)
    }, delay)

    return () => {
      clearTimeout(handler)
    }
  }, [])

  if (disableSpinner) {
    return
  }

  return (
    <div className="animate-in fade-in duration-700">
      <Loader2 className="w-24 h-24 stroke-blue-300 animate-spin" />;
    </div>
  )
}
